/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "lx.h"

int mi_verbose_flag;

int lx_wait (lx_t*lx, unsigned duration, int*variable, int early)
{
  return 1;
}

void mi_println_verbose_function (const char*fmt,...)
{
  va_list args;
  
  va_start (args, fmt);
  vprintf (fmt, args);
  printf ("\n");
}

void mi_fail ()
{
}

int mi_print_hops (FILE*fp, lx_node_t*n, lx_node_t*to, int iport, int oport, lx_route_t*r)
{ 
  int i, p, last;

  insist (fp && n && to && r);
  insist (iport >= 0 && iport < LX_HOST_SIZE);
  insist (oport >= 0 && oport < LX_HOST_SIZE);

  insist (n);
  
  fprintf (fp, lx_node_format ":%d " lx_node_format ":%d ", lx_node_args (n), iport, lx_node_args (to), oport);
 
  last = lx_get_port (n, iport);
  n = lx_get_node (n, iport);
  insist (n);

  for (i = 0; i < r->length; i++)
  {
    fprintf (fp, lx_node_format ":(%dx%d) ", lx_node_args (n), last, last + r->hops [i]);
    
    p = lx_get_port (n, last + r->hops [i]);
    n = lx_get_node (n, last + r->hops [i]);
    insist (n);
    last = p;
  }
  fprintf (fp, "\n");
  
  insist (!r->length || (n == to && last == oport));
  return 1;
  except: return 0;
}

